/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include <Operation.h>

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

int FitPeakAndOutResult()
{
	Worksheet   wks;
    GraphPage   gp;
    GraphLayer	gl;
    
    //create the wks and and graphpage
    gp.Create("line.otp", CREATE_VISIBLE);
    wks.Create("origin.otw",CREATE_VISIBLE); // Newly created worksheet is active
    gl = gp.Layers(0);	//get the graph layer
    
    //get the arcii data
    string strFile = GetOpenBox("*.dat");	//you can select the file \Samples\Curve Fitting\Gaussian.dat file

    ASCIMP    ascimp;
    AscImpReadFileStruct(strFile, &ascimp);
    ascimp.iNumColumns = 2;
    wks.ImportASCII(strFile, ascimp);
    
    //add the result curve data to the worksheet last two columns
    wks.AddCol();
    wks.AddCol();
    int nColNum = wks.GetNumCols();
    
    //plot with the original data
    XYRange xy;
    xy.Add(wks, 0, "X");
    xy.Add(wks, 1, "Y");
    xy.MakePlot(gl);
    
    //create the "FitNL" Operation Object
   	bool bOK = true;
    int	nOption = 0;
   	Operation& op = (Operation &)op_create("FitNL", bOK, nOption); 
   	if(op == NULL)
		return -3;
    
   	//initialize use "Gauss" function
	TreeNode trOp;
	op.GetTree(trOp);
	///////////////////// initialize the operation tree with our xy data and the model to fit 
	int nRet = op.OnInitDataFromOCLT(trOp, trOp.GUI.InputData, xy, "Gauss", "Peak Functions");
	if ( nRet != OP_NOERROR)
	{	
		out_int("OnInitDataFromOCLT err = ", nRet);
		return nRet;
	}
	///////////////////// now we have succeeded in initializing our operation tree with input and other key info
	op.SetTree(trOp);
	
	int nAutoUpdate = 0; // we dont want auto update in this example
	op.OnNoEdit(nOption, nAutoUpdate, NULL); // this step is for the operation class to process and further initialize the trOp
	
	//////////////////// the following are demonstration on how to control the detailed settings before we execute the operation
	op.GetTree(trOp);
	
	//------ set Data Mode for Global Fit
	trOp.GUI.InputData.Use = DATA_MODE_GLOBAL;

    op.SetTree(trOp);
    
    op.Calculate();
   	op.GetTree(trOp);
   	
   	//get the result curves
	TreeNode trResultCurves = trOp.ResultCurves;
    TreeNode trCurve = trResultCurves.FirstNode.FitCurves;
    
    //get the curve data
    vector vFitX, vFitY;
    vFitX = trCurve.FitX.dVals;
    vFitY = trCurve.FitY.dVals;
    
    //set the fit peak datarange and plot
    XYRange xyPeak;
    xyPeak.Add(wks, nColNum - 2, "X");
    xyPeak.Add(wks, nColNum - 1, "Y");
    xyPeak.SetData(&vFitY, &vFitX);
    
    xyPeak.MakePlot(gl);
    gl.Rescale(); //refresh the layer
    
    
    ///set the report tree to the new worksheet
	op.FilterReportForExternal(trOp); // this remove the various branches in the tree like grahs etc that we don't need

	//create new page for the report tree
    WorksheetPage wpg;
	wpg.Create();
	Worksheet wksResult;
	wksResult = wpg.Layers(0);
	
	//add new sheet
	page_add_result_sheet(wpg, wksResult, "Results");
	
	
	wksResult.SetReportTree(trOp.Calculation, 0);
	
	//destroy the operation object
	op_destroy_on_cancel(op);
	return -1;
}